#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>

typedef struct {
    long long x, y;
} Tacka;

int poredi(const void *a, const void *b) {
    Tacka *p1 = (Tacka *)a;
    Tacka *p2 = (Tacka *)b;
    if (p1->x != p2->x)
        return (p1->x < p2->x) ? -1 : 1;
    return (p1->y < p2->y) ? -1 : 1;
}

long long vektor(Tacka p1, Tacka p2, Tacka p3) {
    return (p2.x - p1.x) * (p3.y - p1.y) - (p2.y - p1.y) * (p3.x - p1.x);
}

long long povrsina(Tacka *tacke, int n) {
    long long p = 0;
    for (int i = 0; i < n; i++) {
        long long x1 = tacke[i].x;
        long long y1 = tacke[i].y;
        long long x2 = tacke[(i + 1) % n].x;
        long long y2 = tacke[(i + 1) % n].y;
        p += x1 * y2 - x2 * y1;
    }
    return llabs(p) / 2;
}

long long konveksni(Tacka *tacke, int n, Tacka *om) {
    qsort(tacke, n, sizeof(Tacka), poredi);
    long long k = 0;

    for (int i = 0; i < n; i++) {
        while (k >= 2 && vektor(om[k - 2], om[k - 1], tacke[i]) <= 0)
            k--;
        om[k++] = tacke[i];
    }

    for (int i = n - 2, l = k + 1; i >= 0; i--) {
        while (k >= l && vektor(om[k - 2], om[k - 1], tacke[i]) <= 0)
            k--;
        om[k++] = tacke[i];
    }

    return k - 1;
}

int main() {
    int n;
    scanf("%d", &n);

    Tacka *tacke = malloc(n * sizeof(Tacka));
    for (int i = 0; i < n; i++) {
        scanf("%lld %lld", &tacke[i].x, &tacke[i].y);
    }

    Tacka *om = malloc(2 * n * sizeof(Tacka));
    int omvel = konveksni(tacke, n, om);

    long long minpov = LLONG_MAX;
    for (int i = 0; i < omvel; i++) {
        Tacka *manjom = malloc((omvel - 1) * sizeof(Tacka));
        int c=0;

        for (int j = 0; j < omvel; j++) {
            if (j != i) {
                manjom[c++] = om[j];
            }
        }

        long long pov = povrsina(manjom, c);
        if (pov < minpov)
            minpov = pov;

        free(manjom);
    }

    printf("%lld\n", minpov);

    free(tacke);
    free(om);
    return 0;
}